/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Environment
**
** DESCRIPTION:	Manages environmental effects
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ENVIRONMENT_H
#define ENVIRONMENT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "../Game/TechObserverInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const ldwPoint Environment_c_sAlchemyLabPos(225, 1220);
const ldwPoint Environment_c_sScienceLabPos(425, 1140);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CEnvironment : ITechObserver
{
private:

	//class enumerations
	enum ERef
	{
		eRef_AlchemyLab,
		eRef_DiskRoomLid,
		eRef_DiskRoomDoor,
		eRef_DiskRoomDoorFrame,
		eRef_DiskRoomDoorKeys,
		eRef_MagicHerb,
		eRef_NatureHerb,
		eRef_OverhangingTree,
		eRef_ScienceLab
	};

	//class data
	ldwImageGrid *	m_pAlchemyLab;
	ldwImage *		m_pDiskRoomLid;
	ldwImage *		m_pDiskRoomDoor;
	ldwImage *		m_pDiskRoomDoorFrame;
	ldwImageGrid *	m_pDiskRoomDoorKeys;
	ldwImage *		m_pMagicHerb;
	ldwImage *		m_pNatureHerb;
	ldwImageGrid *	m_pScienceLab;
	ldwImage *		m_pOverhangingTree;

	//class methods
	//setup
	public:		CEnvironment(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	// process
	public:		void Refresh();
	public:		void Update();
	public:		void Draw();
	public:		void Draw(const int iRef) const;
	
	public:		void TechAdvanced(const ETech eTech, const int iLevel);

	// access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CEnvironment		Environment;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/